/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.compat.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockFullMineBase
extends BlockExplosive
implements IIntersectable,
ICustomWailaDisplay {
    private final Block blockDisguisedAs;

    public BlockFullMineBase(Material material, Block disguisedBlock) {
        super(material);
        this.blockDisguisedAs = disguisedBlock;
        if (material == Material.field_151595_p) {
            this.func_149672_a(SoundType.field_185855_h);
        } else if (material == Material.field_151578_c) {
            this.func_149672_a(SoundType.field_185849_b);
        } else {
            this.func_149672_a(SoundType.field_185851_d);
        }
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World world, BlockPos pos) {
        return null;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            this.explode(world, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
    }

    @Override
    public void explode(World world, BlockPos pos) {
        world.func_175655_b(pos, false);
        if (SecurityCraft.config.smallerMineExplosion) {
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), 2.5f, true);
        } else {
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), 5.0f, true);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable().intersectsEntities();
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return false;
    }
}

